import {tns} from "tiny-slider/src/tiny-slider";

export const ProductSlider = (productSlider, previews) => {
	const slider = tns({
		container: productSlider,
		items: 1,
		controls: false,
		autoplayButtonOutput: false,
		nav: false,
		mouseDrag: true
	});

	previews.forEach((el) => {
		el.addEventListener('click', () => {
			const id = el.dataset.slideId;
			slider.goTo(id);
		});
	})
};
