import noUiSlider           from 'nouislider'
import {slideDown, slideUp} from "es6-slide-up-down";
import {checkMedia}         from './utilities/utitlities'
import {addEventForChild}   from '../../../../../core/assets/admin/src/js/utils/Functions';

window.showSearch = function () {
	document.querySelector('.shop-header__search').classList.toggle('active');
};

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * Inicializace price filtru pro ProductsFilter.latte
	 */
	initPriceRange();
	initShowMore();

	/**
	 * Inicializace po requestu
	 */
	global.naja.addEventListener('complete', e => {
		initPriceRange();
		initVariantPopupChange();
		initShowMore();
	});

	/**
	 * Skryvani a odkryvani filtru na responzivni verzi
	 */
	document.querySelectorAll('[data-show-filter]').forEach(el => {
		el.addEventListener('click', () => {
			const id            = el.dataset.showFilter;
			const parent        = el.parentNode;
			const targetElement = parent.querySelector(`[data-filter-group="${id}"]`);
			if (!targetElement.classList.contains('active')) {
				slideDown(targetElement);
				targetElement.classList.add('active');
			} else {
				slideUp(targetElement);
				targetElement.classList.remove('active');
			}
		});
	});

	/**
	 * Popup na varianty funkce
	 */
	addEventForChild(document.querySelector('body'), 'click', '.variant-box__value', (el) => {
		document.querySelectorAll('.variant-box__value').forEach(el => el.classList.remove('light-grey-bg-color'))
		el.classList.add('light-grey-bg-color');
		const variant    = {
			id         : el.dataset.id,
			price      : el.dataset.price,
			retailPrice: el.dataset.retailPrice,
			image      : el.dataset.image,
			name       : el.dataset.name,
		};
		const attributes = [];

		let retailPriceEl = document.querySelector('.variant-modal__old-price');
		if (variant.retailPrice) {
			retailPriceEl.textContent = variant.retailPrice;
			retailPriceEl.classList.remove('hidden');
		} else {
			retailPriceEl.classList.add('hidden');
		}
		document.querySelector('.variant-modal__price').textContent = variant.price;
		document.querySelectorAll('.cart-add-wrap').forEach(el => {
			el.classList.add('hidden');
		});
		document.querySelector('.cart-add-wrap[data-id="' + variant.id + '"]').classList.remove('hidden');

		const variantImg          = document.querySelector('.variant-modal__left img');
		variantImg.attributes.src = variant.image;
		variantImg.attributes.alt = variant.name;
	});


	// Presunuti kosiku desktop vs mobil
	moveShopHeaderCart();
	window.addEventListener('resize', (e) => {
		moveShopHeaderCart();
	});
});

let shopHeaderCartLastPos = 'desktop';
const moveShopHeaderCart  = () => {
	let mobileSize = checkMedia(document.body.dataset.responsiveBarThreshold);
	let moveTo     = null;
	if (mobileSize && shopHeaderCartLastPos === 'desktop')
		moveTo = 'mobile';
	else if (!mobileSize && shopHeaderCartLastPos === 'mobile')
		moveTo = 'desktop';

	if (moveTo) {
		let shopHeaderCartMobile  = document.querySelector('.shop-header__cart-mobile');
		let shopHeaderCartDesktop = document.querySelector('.show-header__cart-desktop');

		if (moveTo === 'mobile') {
			while (shopHeaderCartDesktop.childNodes.length > 0)
				shopHeaderCartMobile.appendChild(shopHeaderCartDesktop.childNodes[0]);
			shopHeaderCartLastPos = 'mobile';
		} else if (moveTo === 'desktop') {
			while (shopHeaderCartMobile.childNodes.length > 0)
				shopHeaderCartDesktop.appendChild(shopHeaderCartMobile.childNodes[0]);
			shopHeaderCartLastPos = 'desktop';
		}
	}
}

const initPriceRange = () => {
	let slider = document.getElementById('price-slider');

	if (!slider || slider.classList.contains('init'))
		return;

	slider.classList.add('init');

	const min    = Math.round(slider.dataset.min);
	const max    = Math.round(slider.dataset.max);
	const start  = Math.round(slider.dataset.start);
	const end    = Math.round(slider.dataset.end);
	const parent = slider.parentNode;
	const input0 = parent.querySelector('#input-with-keypress-0');
	const input1 = parent.querySelector('#input-with-keypress-1');
	const inputs = [input0, input1];

	noUiSlider.create(slider, {
		start   : [min, max],
		range   : {min: start, max: end},
		tooltips: [true, true],
		format  : {
			to  : function (value) {
				return Math.round(value) + ' Kč'
			},
			from: function (value) {
				return Number(value.replace(',-', ''));
			}
		}
	});

	slider.noUiSlider.on('change', function (values, handle, unencoded, tap, positions) {
		document.querySelector('[name="priceRange[min]"]').value = parseInt(unencoded[0]);
		document.querySelector('[name="priceRange[max]"]').value = parseInt(unencoded[1]);

		let link = slider.dataset.updateLink.replace('__min__', parseInt(unencoded[0])).replace('__max__', parseInt(unencoded[1]));
		global.naja.makeRequest('get', link, [], {
			history: true,
		});

	});

	slider.noUiSlider.on('update', function (values, handle, rawValue, bool, percentageValue) {
		inputs[handle].innerHTML = values[handle];
	});
};

const initVariantPopupChange = () => {
	document.querySelectorAll('.variant-box__value:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			e.preventDefault();

			// Nastaveni ID produktu do komponenty kosiku
			document.querySelector('.variant-modal [name="productId"]').value = el.dataset.id;

			return false;
		});
	});
}

/**
 * Skryvani a odkryvani pomoci zobrazit dalsi
 * TODO temporary fix for IE SlideDown / Up
 */
const initShowMore = () => {
	document.querySelectorAll('[data-show-more]').forEach(el => {
		if (el.dataset.showMore === 'init')
			return true;

		el.addEventListener('click', (e) => {
			e.preventDefault();
			const targetEl = el.parentNode.querySelector('[data-hidden-content]');
			if (!targetEl.classList.contains('active')) {
				targetEl.style.display = "block";
				targetEl.classList.add('active');
				el.classList.add('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.hide;
			} else {
				targetEl.style.display = "none";
				targetEl.classList.remove('active');
				el.classList.remove('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.show;
			}
		});
	});
}
