<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use Doctrine\ORM\Query;
use EshopCatalog\AdminModule\Model\Products;

class ProductsPresenter extends BasePresenter
{
	/** @var Products */
	protected Products $products;

	public function __construct(Products $products)
	{
		$this->products = $products;
	}

	public function actionFindByTerm(string $term = '', array $excluded = [])
	{
		$output = [];
		foreach ($this->products->getByTerm($term, Query::HYDRATE_ARRAY) as $product) {
			if (!in_array($product['id'], $excluded)) {
				$output[$product['id']] = [
					'id'    => $product['id'],
					'name'  => $product['productTexts'][$this->translator->getLocale()]['name'],
					'code1' => $product['code1'],
					'ean'   => $product['ean'],
				];
			}
		}

		$this->sendJson($output);
	}
}
