<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Entities\TSeo;
use Nette\Utils\DateTime;

/**
 * Class Category
 * @package EshopCatalog\FrontModule\Model\Dao
 */
class Category
{
	use TSeo;

	/** @var int */
	public $id;

	/** @var string */
	public $name;

	/** @var string */
	public $nameH1;

	/** @var string */
	public $alias;

	/** @var string */
	public $shortDescription;

	/** @var string */
	public string $description;

	/** @var string */
	public $image;

	/** @var int */
	public $lvl;

	/** @var self[] */
	public $child = [];

	/** @var int */
	protected $parentId;

	/** @var self */
	protected $parent;

	/** @var string */
	public $link = '#';

	/** @var DateTime */
	public $created;

	/** @var DateTime */
	public $modified;

	/** @var int */
	public $filtersFromParent;

	/** @var array */
	public $attrs;

	/** @var string */
	public $rod;

	/** @var bool */
	public bool $canProductsAddToCart = true;

	public function getId(): int { return $this->id; }

	public function getNameH1(): string { return $this->nameH1 ?: $this->name; }

	public function setParent(Category &$category): self
	{
		$this->parent = &$category;

		return $this;
	}

	public function getParent(): ?Category { return $this->parent; }

	public function setParentId(int $id): self
	{
		$this->parentId = $id;

		return $this;
	}

	public function getParentId(): ?int { return $this->parentId; }

	public function setChild(array $arr): self
	{
		$this->child = $arr;

		return $this;
	}

	public function getRoot(): ?Category
	{
		$r = $this->getParent();

		while ($r && $r->getParent())
			$r = $r->getParent();

		return $r;
	}

	/**
	 * @return Category[]
	 */
	public function getChild(): array { return $this->child ?: []; }

	public function setAttrs(array $attrs): self
	{
		$this->attrs = $attrs;

		return $this;
	}

	public function getAttr(string $key) { return $this->attrs[$key] ?? null; }

	public function getAttrs(): array { return $this->attrs ?: []; }
}
