<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	protected RouteHelper $routeHelper;

	public function __construct(RouteHelper $routeHelper)
	{
		$this->routeHelper = $routeHelper;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopCatalog:Front');
		$front[] = $this->routeHelper->createRoute('/eshopcatalog/documents/<action>[/<id>]', 'Documents:default');

		return $router;
	}
}
