<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Sites;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\ProductQuery;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopCatalog\FrontModule\Model\Tags;
use EshopCatalog\Model\Entities\Product;
use Core\Model\Entities\EntityManagerDecorator;
use Nette\Localization\ITranslator;

class ProductsWithTag extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogProductsWithTag';

	protected ProductsFacade $productsFacade;

	protected EntityManagerDecorator $em;

	protected ITranslator $translator;

	protected Sites $sitesService;

	protected Tags $tagsService;

	public function __construct(ProductsFacade $productsFacade, EntityManagerDecorator $entityManager, ITranslator $translator,
	                            Sites $sites, Tags $tags)
	{
		$this->productsFacade = $productsFacade;
		$this->em             = $entityManager;
		$this->translator     = $translator;
		$this->sitesService   = $sites;
		$this->tagsService    = $tags;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		if (!isset($params['tag']) || !isset($params['limit']))
			$container = $formContainer->addContainer($params['name']);

		if (!isset($params['tag'])) {
			$opts = ['' => ''];
			foreach ($this->tagsService->getAll() as $tag) {
				$opts[$tag->type] = $tag->name;
			}
			$container->addSelect('tag', 'eshopCatalog.templateTextFields.tagId', $opts);
		}

		if (!isset($params['limit'])) {
			$container->addText('limit', 'eshopCatalog.templateTextFields.limit')
				->setHtmlType('number')
				->setValue(6);
		}
	}

	public function render($params)
	{
		$default         = $this->getDefault();
		$params['tag'] = $params['tag'] ?: $default['tag'] ?? null;
		$params['limit'] = $params['limit'] ?: $default['limit'] ?? null;

		if (!isset($params['toVar'])) {
			bdump('Need variable for output');

			return [];
		}
		if (!isset($params['tag'])) {
			bdump('Need tag for output');

			return [];
		}

		$query = (new ProductQuery($this->translator->getLocale()))
			->withTexts(false)
			->withTag($params['tag'])
			->inSite($this->sitesService->getCurrentSite()->getIdent())
			->selectIds();

		$ids = array_map(function($r) { return $r['id']; }, $query->getQueryBuilder($this->em->getRepository(Product::class))
			->orderBy('RAND()')->getQuery()
			->setMaxResults($params['limit'])->useResultCache(true, 60)->getScalarResult());

		return $this->productsFacade->getProducts($ids);
	}
}
