<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\Lang\DefaultLang;
use Core\Model\UI\Form\BaseContainer;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Tags;
use EshopCatalog\Model\Entities\Tag;

class TagsContainer
{
	/** @var DefaultLang */
	protected $defaultLang;

	/** @var Categories */
	protected $tagServices;

	public function __construct(Tags $tags, DefaultLang $defaultLang)
	{
		$this->tagServices = $tags;
		$this->defaultLang = $defaultLang;
	}

	public function getContainer()
	{
		$container = new BaseContainer();

		$tags = $this->tagServices->getEr()->createQueryBuilder('t')
			->select('t.type, tt.name')
			->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->defaultLang->locale)
			->getQuery()->getResult();

		foreach ($tags as $key => $t) {
			$container->addCheckbox($t['type'], $t['name']);
			$container->addDatePicker('dateFrom' . $t['type'], 'eshopCatalog.tagContainer.dateFrom')->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container->addDatePicker('dateTo' . $t['type'], 'eshopCatalog.tagContainer.dateTo')->setDescription('eshopCatalog.tagContainer.dateDesc');
		}


		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 *
	 * @return array
	 */
	public function getFormData($values): array
	{
		return (array) $values;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values)
	{
		foreach ($container->getControls() as $c) {
			if (isset($values[$c->getName()]))
				$c->setDefaultValue($values[$c->getName()]);
		}
	}
}
