<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__feature_texts")
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureListener"})
 */
class FeatureTexts
{
	/**
	 * @var Feature
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="featureTexts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	public function __construct($id, $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	/**
	 * @return Feature
	 */
	public function getFeature() { return $this->id; }

	public function getLang()
	{
		return $this->lang;
	}
}

