<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__supplier")
 */
class Supplier
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="logo", type="string", length=255, nullable=true)
	 */
	public $logo;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", length=1)
	 */
	public $isPublished;

	/**
	 * @var SupplierTexts
	 *
	 * @ORM\OneToMany(targetEntity="SupplierTexts", mappedBy="id", indexBy="lang", cascade={"all"})
	 */
	protected $supplierTexts;

	/**
	 * @var ProductSupplier
	 *
	 * @ORM\OneToMany(targetEntity="ProductSupplier", mappedBy="supplier", orphanRemoval=true, cascade={"persist", "remove"})
	 */
	protected $products;

	public function __construct($name)
	{
		$this->name          = $name;
		$this->products      = new ArrayCollection();
		$this->supplierTexts = new ArrayCollection();
		$this->isPublished   = 0;
	}

	public function addSupplierText($lang)
	{
		$this->supplierTexts->set($lang, new SupplierTexts($this, $lang));
	}

	public function setSupplierText(SupplierTexts $supplierTexts)
	{
		$this->supplierTexts->set($supplierTexts->getLang(), $supplierTexts);
	}

	public function getSupplierText($lang)
	{
		return $this->supplierTexts->get($lang);
	}
}
