<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use EshopCatalog\FrontModule\Model\Categories;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\FrontModule\Model\Products;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\FrontModule\Model\TemplatePages;

class Export extends BaseNavigation implements INavigationItem
{
	protected $title = 'export';

	protected $presenter         = 'EshopCatalog:Front:Export';
	protected $actionPorovnavace = 'porovnavace';

	protected const URL_POROVNAVACE = 'porovnavace';

	/** @var Categories */
	protected $categoriesService;

	/** @var Products */
	protected $productsService;

	/** @var TemplatePages */
	protected $templatePagesService;

	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Categories $categories, Products $products, TemplatePages $templatePages)
	{
		$this->categoriesService    = $categories;
		$this->productsService      = $products;
		$this->templatePagesService = $templatePages;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->actionPorovnavace == $action) {
			return 1;
		}

		return false;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array|mixed
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		$return = [
			'presenter' => $this->presenter,
			'action'    => null,
			'id'        => null,
		];

		if (isset($urlParams['path'])) {

			$params      = explode('/', $urlParams['path']);
			$lastSegment = array_pop($params);

			if ($lastSegment == self::URL_POROVNAVACE) {
				$return = [
					'presenter' => $this->presenter,
					'action'    => $this->actionPorovnavace,
					'id'        => null,
				];
			}
		}

		return $return;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;

		if ($urlParams['action'] == $this->actionPorovnavace) {
			$urlParts[] = self::URL_POROVNAVACE;
		}

		$url = '/' . implode('/', $urlParts);

		return $url;
	}
}
