<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Doctrine\ORM\EntityManager;
use Navigations\Model\Event\RouteOutEvent;
use EshopCatalog\Model\Navigation\BaseNavigation;
use EshopCatalog\Model\NavigationFilter;

class NavigationSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $entityManager;

	/** @var NavigationFilter */
	protected $navigationFilter;

	public function __construct(EntityManager $entityManager, NavigationFilter $navigationFilter)
	{
		$this->entityManager    = $entityManager;
		$this->navigationFilter = $navigationFilter;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			BaseNavigation::class . '::routeOut' => ['routeOut', 100],
		];
	}

	public function routeOut(RouteOutEvent $event): void
	{
		if ($event->disableDefaultFilter === true)
			return;

		$urlParams = &$event->urlParams;
		$url       = &$event->url;

		$event->urlParams = $this->navigationFilter->processRouterOut($urlParams);
	}
}
