<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductPriceHistory;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductPriceHistoryListener implements EventSubscriberInterface
{
	protected CacheService $cacheService;

	public function __construct(
		CacheService $cacheService
	)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 */
	public function onPostPersist(ProductPriceHistory $entity, LifecycleEventArgs $args): void
	{
		$this->cacheService->priceCache->remove('retailPrice/' . $entity->product->getId());
	}
}
