document.addEventListener('DOMContentLoaded', () => {
	document.addEventListener('click', e => {
		const el = e.target;

		if (el.matches('.variant-box__value') && el.closest('.modal')) {
			e.preventDefault();

			// Nastaveni ID produktu do komponenty kosiku
			document.querySelector('.variant-modal [name="productId"]').value = el.dataset.id;

			document.querySelectorAll('.variant-box__value').forEach(el => el.classList.remove('light-grey-bg-color'))
			el.classList.add('light-grey-bg-color');
			const variant    = {
				id         : el.dataset.id,
				price      : el.dataset.price,
				retailPrice: el.dataset.retailPrice,
				image      : el.dataset.image,
				name       : el.dataset.name,
			};
			const attributes = [];

			let retailPriceEl = document.querySelector('.variant-modal__old-price');
			if (variant.retailPrice) {
				retailPriceEl.textContent = variant.retailPrice;
				retailPriceEl.classList.remove('hidden');
			} else {
				retailPriceEl.classList.add('hidden');
			}
			document.querySelector('.variant-modal__price').textContent = variant.price;
			document.querySelectorAll('.cart-add-wrap').forEach(el => {
				el.classList.add('hidden');
			});
			document.querySelector('.cart-add-wrap[data-id="' + variant.id + '"]').classList.remove('hidden');

			const variantImg          = document.querySelector('.variant-modal__left img');
			variantImg.attributes.src = variant.image;
			variantImg.attributes.alt = variant.name;
		}
	})
});
