<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model\FormContainers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Strings;
use Core\Model\SystemConfig;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\ProductVideo;
use Nette\Http\FileUpload;
use Nette\Localization\Translator;
use Nette\Utils\ArrayHash;
use Nette\Utils\Validators;

class VideoContainer
{
	protected Translator $translator;
	protected EntityManagerDecorator $em;

	public function __construct(Translator $translator, EntityManagerDecorator $em)
	{
		$this->translator = $translator;
		$this->em = $em;
	}

	public function getContainer(bool $multilang = false): BaseContainer
	{
		$container = new BaseContainer();
		$container->addCustomData('template', __DIR__ . '/VideoContainer.latte');

		for ($i = 0; $i < Config::load('maxVideosToUpload', 5); $i++) {
			$videoContainer = new BaseContainer();

			$videoContainer->addText('url')
						   ->setPlaceholder($this->translator->translate('eshopCatalog.videos.url'))
						   ->addCondition(BaseForm::FILLED)
						   ->addRule(BaseForm::URL);
			$videoContainer->addText('title')
						   ->setPlaceholder($this->translator->translate('eshopCatalog.videos.title'));
			$videoContainer->addLangsSelect('lang', 'eshopCatalog.videos.lang')
						   ->setPrompt(null);
			$videoContainer->addHidden('removeLink');
			$videoContainer->addHidden('id');

			$videoContainer['lang']->setItems([null => 'eshopCatalog.videos.lang'] + $videoContainer['lang']->getItems());

			$container->addComponent($videoContainer, 'video_' . $i);
		}

		return $container;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values): void
	{
		$i = 0;
		foreach ($container->getComponents() as $videoContainer) {
			foreach ($videoContainer->getControls() as $c) {
				if (isset($values[$i][$c->getName()])) {
					$c->setDefaultValue($values[$i][$c->getName()]);
				}
			}
			$i++;
		}
	}

	public function saveData(ArrayHash $data, Product $product): void
	{
		foreach ($data as $video) {
			if (!$video['url'])
				continue;

			if (Validators::isNone($video['id'])) {
				$this->em->persist(new ProductVideo($product, empty($video['lang']) ? null : $video['lang'], $video['url'], $video['title']));
			} else {
				foreach ($product->getVideos() as $v) {
					if ($v->getId() === ((int) $video['id'])) {
						$v->lang = empty($video['lang']) ? null : $video['lang'];
						$v->url = $video['url'] ?? null;
						$v->title = $video['title'] ?? null;
						$this->em->persist($v);
						break;
					}
				}
			}
		}
	}

}