<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\Model\Entities\Tag;
use Nette\Localization\ITranslator;

/**
 * Class Tags
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Tag|null|object = getReference($id)
 * @method Tag[]|null getAll()
 * @method Tag|null get($id)
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	/** @var ITranslator */
	protected ITranslator $translator;

	/** @var array|null */
	protected ?array $cOptionsForSelect = null;

	public function __construct(ITranslator $translator)
	{
		$this->translator = $translator;
	}

	public function getByType(string $type): ?Tag
	{
		return $this->getEr()->createQueryBuilder('t')->addSelect('tt')
			->leftJoin('t.texts', 'tt')
			->where('t.type = :type')->setParameter('type', $type)
			->getQuery()->getOneOrNullResult();
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];

			foreach ($this->getEr()->createQueryBuilder('t')->select('t.id, t.type, tt.name')
				         ->leftJoin('t.texts', 'tt', Join::WITH, 'tt.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOptionsForSelect[$row['id']] = trim($row['name'] . ' (' . $row['type'] . ')');
			}
		}

		return $this->cOptionsForSelect;
	}
}
