<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Helpers\ShowedProducts;
use EshopCatalog\FrontModule\Model\ProductsFacade;

class ProductPreview extends BaseControl
{
	/** @var ProductsFacade */
	protected $productsFacade;

	/** @var ICartAddFormFactory */
	protected $cartAddFormFactory;

	/** @var IVariantsPopupFactory */
	protected $variantsPopupFactory;

	/** @var Product */
	protected $product;

	/** @var string */
	public $templateFileName = 'ProductPreview';

	public function __construct(ProductsFacade $productsFacade,
	                            ICartAddFormFactory $cartAddForm, IVariantsPopupFactory $variantsPopupFactory)
	{
		$this->productsFacade       = $productsFacade;
		$this->cartAddFormFactory   = $cartAddForm;
		$this->variantsPopupFactory = $variantsPopupFactory;
	}

	public function render(): void
	{
		$this->template->product = $this->product;
		ShowedProducts::addShowProduct($this->product->getId());
		$this->template->render($this->getTemplateFile($this->templateFileName, 'ProductPreview'));
	}

	protected function createComponentCartAddForm(): CartAddForm
	{
		$control = $this->cartAddFormFactory->create();
		$control->setProduct($this->product);

		return $control;
	}

	protected function createComponentVariantsPopup(): VariantsPopup
	{
		return $this->variantsPopupFactory->create($this->product);
	}

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function setProductById(int $id): self
	{
		$this->product = $this->productsFacade->getProduct($id);

		return $this;
	}
}
