<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;

/**
 * Class SearchForm
 * @package EshopCatalog\FrontModule\Components
 */
class SearchForm extends BaseControl
{

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAction($this->getPresenter()->link(':EshopCatalog:Front:Default:search'));
		$form->setMethod('post');
		$form->getElementPrototype();

		$form->addText('q', '');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$this->getPresenter()->redirect(':EshopCatalog:Front:Default:search', ['q' => urlencode($values->q)]);
	}
}
