<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Spatie\SchemaOrg\ItemAvailability;

class Availability
{

	/** @var int */
	protected $id;

	/** @var string */
	protected $ident;

	/** @var string */
	protected $name;

	/** @var string */
	protected $description;

	/** @var int */
	protected $delay;

	/** @var string */
	protected $textColor;

	/** @var string */
	protected $bgColor;

	/** @var int */
	protected $canShowOnList;

	/** @var int */
	protected $canShowOnSearch;

	/** @var int */
	protected $canAddToCart;

	protected ?string $openGraphText = null;

	public function setData(array $data)
	{
		foreach ($data as $k => $v) {
			$this->$k = $v;
		}
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getIdent(): string
	{
		return $this->ident;
	}

	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}

	/**
	 * @return string
	 */
	public function getDescription(): string
	{
		return $this->description;
	}

	/**
	 * @return int
	 */
	public function getDelay(): int
	{
		return $this->delay;
	}

	/**
	 * @return string
	 */
	public function getTextColor(): string
	{
		return $this->textColor;
	}

	/**
	 * @return string
	 */
	public function getBgColor(): string
	{
		return $this->bgColor;
	}

	/**
	 * @return int
	 */
	public function canShowOnList(): int
	{
		return $this->canShowOnList;
	}

	/**
	 * @return int
	 */
	public function canShowOnSearch(): int
	{
		return $this->canShowOnSearch;
	}

	/**
	 * @return int
	 */
	public function canAddToCart(): int
	{
		return $this->canAddToCart;
	}

	/**
	 * @return string|null
	 */
	public function getOpenGraphText(): ?string
	{
		return $this->openGraphText;
	}

	public function getSchemaUrl(): string
	{
		switch ($this->getOpenGraphText()) {
			case 'in stock':
				return ItemAvailability::InStock;
				break;
			case 'preorder':
			case 'available for order':
				return ItemAvailability::PreOrder;
				break;
			case 'discontinued':
				return ItemAvailability::Discontinued;
				break;
			default:
				return ItemAvailability::SoldOut;
		}
	}
}
