<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\FrontModule\Model\Dao;
use EshopCatalog\Model\Entities\ProductDocument;
use Nette\Application\LinkGenerator;
use Nette\Localization\ITranslator;

class ProductDocuments
{
	/** @var EntityManagerDecorator */
	protected EntityManagerDecorator $em;

	/** @var ITranslator */
	protected ITranslator $translator;

	/** @var Dao\Document[] */
	protected array $cDocuments = [];

	public function __construct(EntityManagerDecorator $em, ITranslator $translator)
	{
		$this->em         = $em;
		$this->translator = $translator;
	}

	/**
	 * @param array $ids
	 *
	 * @return Dao\Document[][]
	 */
	public function getDocuments(array $ids): array
	{
		$whereIds = [];
		$result   = [];
		$locale   = $this->translator->getLocale();

		foreach ($ids as $id) {
			if (isset($this->cDocuments[$id]))
				$result[$id] = $this->cDocuments[$id];
			else
				$whereIds[] = $id;
		}

		if (!empty($whereIds)) {
			$qb = $this->em->getRepository(ProductDocument::class)->createQueryBuilder('pd')
				->select('IDENTITY(pd.product) as product, pd.name, pd.file')
				->where('pd.product IN (:ids)')
				->andWhere('pd.lang IS NULL OR pd.lang = :lang')
				->setParameters([
					'ids'  => $whereIds,
					'lang' => $locale,
				]);

			foreach ($qb->getQuery()->getArrayResult() as $row) {
				$this->cDocuments[$row['product']][] = $this->fillDao($row);
			}

			foreach ($whereIds as $id) {
				if (!isset($this->cDocuments[$id]))
					$this->cDocuments[$id] = [];
				else
					$result[$id] = $this->cDocuments[$id];
			}
		}

		return $result;
	}

	protected function fillDao(array $data): Dao\Document
	{
		return new Dao\Document($data['name'], $data['file']);
	}
}
