<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;
use Nette\Localization\ITranslator;

class RouterFactory
{
	protected RouteHelper $routeHelper;

	protected ITranslator $translator;

	protected bool $allowPersooSearchPage = false;

	public function __construct($allowPersooSearchPage, RouteHelper $routeHelper, ITranslator $translator)
	{
		$this->allowPersooSearchPage = (bool) $allowPersooSearchPage;
		$this->routeHelper           = $routeHelper;
		$this->translator            = $translator;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopCatalog:Front');
		$front[] = $this->routeHelper->createRoute('/eshopcatalog/documents/<action>[/<id>]', 'Documents:default');

		if ($this->allowPersooSearchPage)
			$front[] = $this->routeHelper->createRoute(
				sprintf('/%s/', $this->translator->translate('eshopCatalogFront.persoo.searchResultsUrl')), 'Default:persooSearch');

		return $router;
	}
}
