
// initialization of items
const initDocuments = () => {
	let items = document.querySelectorAll('#item-documents .row');
	let count = items.length;

	items.forEach(function (el, key) {
		el.classList.add('d-none');
	});

	let i = -1;
	document.querySelectorAll('#item-documents input[name*=id]').forEach(function (element, k) {
		if (element.value.length > 0) {
			items.forEach(function (el, key) {
				if (key <= k) {
					el.classList.remove('d-none');
				}
				i = k;
			});
		}
	});

	if ((i + 1) < count) {
		items[i + 1].classList.remove('d-none');
	}
}

const initAddButton = () => {
	// add row by btn
	document.getElementById('document-add').addEventListener('click', (e) => {
		e.stopPropagation();
		let items = document.querySelectorAll('#item-documents .row');
		let count = items.length;

		// remember last filled row
		let k = null;
		document.querySelectorAll('#item-documents .row:not(.d-none)').forEach(function (el, key) {
			k = key;
		})
		// first empty row after filled row show
		if (k !== null && (k + 1) < count) {
			items[k + 1].classList.remove('d-none');
		}

	});
};

const initRemoveButtons = () => {
	document.querySelectorAll('#item-documents .remove-document').forEach(function (el, key) {
		el.addEventListener('click', () => {
			let link = document.querySelectorAll('#item-documents input[name*=removeLink]')[key];

			if (link.value.length > 0) {
				window.naja.makeRequest('post', link.value, {}, {
					history: false
				});
			}

			document.querySelectorAll('#item-documents .row')[key].querySelectorAll('input, select').forEach((el, key) => {
				if (el.tagName === 'SELECT') {
					el.selectedIndex = 0;
				} else {
					el.value = null;
				}
				initDocuments();
			});
		})
	});
};

document.addEventListener('DOMContentLoaded', () => {
	initAddButton();
	initRemoveButtons();
	initDocuments();
	window.naja.addEventListener('complete', () => {
		initRemoveButtons();
		initDocuments();
	});
});
