const initProductCardHandler = () => {
	for (const el of document.querySelectorAll('.product-card > a')) {
		el.addEventListener('click', async e => {
			let id = null
			if (e.target.tagName !== 'A') {
				id = e.target.closest('a').dataset.id
			} else {
				id = e.target.dataset.id
			}

			window.disableLoader = true

			global.naja.makeRequest('post', window.personalizationAlternativeProducts.apiUrlCtr, {productId: id}, {
				history: false,
			})
		})
	}
}

document.addEventListener('DOMContentLoaded', e => {
	initProductCardHandler()
})