const initSearchForm = () => {
	const form = document.getElementById('autocomplete-form')
	const searchBox = document.querySelector('[data-autocomplete-box]')
	const searchInput = form?.querySelector('[name=q]')
	const searchResults = searchBox?.querySelector('[data-autocomplete-results]')

	if (!searchInput || !searchBox || !searchResults) {
		return
	}

	searchInput.addEventListener('input', e => {
		const val = e.target.value
		if (val) {
			searchResults.style.display = null

			fetch(window.personalizationAutocomplete.apiUrl.replace('__VAL__', val))
				.then(res => res.json())
				.then(data => {
					const wrapper = document.querySelector('[data-autocomplete-results]')
					wrapper.innerHTML = ''

					if (data.length > 0) {
						wrapper.insertAdjacentHTML('afterbegin', `<h2>${window.personalizationAutocomplete.texts.productsFound} <span class="badge">${data.length}</span></h2>`)
						const productsResultElement = document.createElement('div')
						productsResultElement.classList.add('products-result')

						data.forEach((el, i) => {
							const a = document.createElement('a')
							a.href = el.databaseId
							a.classList.add('product')

							a.insertAdjacentHTML('beforeend', `<div class="product__image"><img srcset="${el.img} 450w" src="${el.img}" alt="${el.title}" /></div>`)
							a.insertAdjacentHTML('beforeend', `<div class="product__info"><div class="product__title"><h3>${el.title}</h3></div><div class="product__prices"><span class="product__price">${el.price} ${window.personalizationAutocomplete.texts.currency}</span><span class="product__price-label">${window.personalizationAutocomplete.texts.priceWithTax}</span></div></div>`)

							productsResultElement.insertAdjacentElement('beforeend', a)
						})

						wrapper.insertAdjacentElement('beforeend', productsResultElement)
					} else {
						wrapper.insertAdjacentHTML('afterbegin', `<h2 class="justify-content-center">${window.personalizationAutocomplete.texts.productsNotFoud}`)
					}
				})
		}
	})

	document.addEventListener('click', e => {
		if (e.target.closest('[data-autocomplete-box]') && searchInput.value) {
			searchResults.style.display = null
		} else {
			searchResults.style.display = 'none'
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initSearchForm()
})