<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Utils\DateTime;
use Nette\Utils\Html;

class EmailTextEnd extends Widget implements IWidget
{
	protected string $gridSize = 'col-md-4 col-xxl-3';

	protected string $key = 'eshopCatalogEmailTextEnd';

	public function render(): void
	{
		if (!EshopOrdersConfig::load('enableGlobalOrderEmailMessage') || !EshopOrdersConfig::load('showGlobalOrderEmailMessageOnDashboard')) {
			return;
		}

		$this->template->key   = $this->getKey();
		$this->template->icon  = 'fas fa-envelope';
		$this->template->title = $this->t('eshopCatalog.dashboardWidget.emailEndText.title');

		$settings = $this->settings->getAll();

		$now  = (new DateTime)->setTime(0, 0, 0)->getTimestamp();
		$from = $settings['eshopOrdersGlobalOrderEmailFrom']
			? DateTime::createFromFormat('d.m.Y H:i', $settings['eshopOrdersGlobalOrderEmailFrom'])
			: false;
		$to   = $settings['eshopOrdersGlobalOrderEmailTo']
			? DateTime::createFromFormat('d.m.Y H:i', $settings['eshopOrdersGlobalOrderEmailTo'])
			: false;

		$text = null;
		if (($from === false || $from->getTimestamp() <= $now) && ($to === false || $to->getTimestamp() >= $now)) {
			$text = $settings['eshopOrdersGlobalOrderEmailMessageText'][$this->translator->getLocale()];
		}

		$this->template->text = $text ? Html::fromHtml($text) : null;

		$this->template->render($this->getTemplateFile());
	}
}
