<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\FormContainers\ProductSpeditionContainer;
use EshopCatalog\Model\Config;
use Nette\InvalidArgumentException;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Products;

class ProductsSpeditionsForm extends BaseControl
{
	private string                      $ids = '';
	protected Products                  $productServices;
	protected ProductSpeditionContainer $speditionContainer;

	public function __construct(
		Products                  $products,
		ProductSpeditionContainer $speditionContainer
	)
	{
		$this->productServices    = $products;
		$this->speditionContainer = $speditionContainer;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		if (!Config::load('product.allowModifySpedition', false)) {
			return $form;
		}

		$form->addHidden('produtcIds', $this->ids);
		$form->addComponent($this->speditionContainer->getContainer(true), 'speditions');

		$form->addSaveCancelControl();
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$this->speditionContainer->saveData($values->speditions, explode('-', $this->ids));
		$this->em->flush();

		$form->addCustomData('productIds', $this->ids);

		return true;
	}

	public function setProducts(?string $ids): void
	{
		if (!$ids) {
			throw new InvalidArgumentException;
		}

		$this->ids = $ids;
	}

}
