<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\Lang\DefaultLang;
use Core\Model\UI\Form\BaseContainer;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Tags;

class TagsContainer
{
	protected DefaultLang $defaultLang;
	protected Tags        $tagServices;

	public function __construct(
		Tags        $tags,
		DefaultLang $defaultLang
	)
	{
		$this->tagServices = $tags;
		$this->defaultLang = $defaultLang;
	}

	public function getContainer(): BaseContainer
	{
		$container = new BaseContainer;

		$tags = $this->tagServices->getEr()->createQueryBuilder('t')
			->select('t.id, t.type, tt.name')
			->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->defaultLang->locale)
			->getQuery()->getResult();

		foreach ($tags as $t) {
			$container2 = new BaseContainer;
			$container2->addBool('active', $t['name']);
			$container2->addDateTimePicker('dateFrom', 'eshopCatalog.tagContainer.dateFrom')->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addDateTimePicker('dateTo', 'eshopCatalog.tagContainer.dateTo')->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addHidden('id', (string) $t['id']);

			$container->addComponent($container2, $t['type']);
		}

		$container->addCustomData('template', __DIR__ . '/TagsContainer.latte');

		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 */
	public function getFormData($values): array
	{
		return (array) $values;
	}

	/**
	 * @param BaseContainer   $container
	 * @param array|ArrayHash $values
	 */
	public function setDefaults(BaseContainer $container, $values): void
	{
		$container->setDefaults($values);
	}

}
