<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Exceptions\EntityHasRelations;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use EshopCatalog\Model\Entities\Availability;
use EshopCatalog\Model\Entities\Product;

/**
 * @method Availability|null getReference($id)
 * @method Availability[] getAll()
 * @method Availability|null get($id)
 */
class AvailabilityService extends BaseEntityService
{
	use TPosition;

	protected $entityClass = Availability::class;
	protected Translator $translator;
	protected ?array $cOptions = null;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @return Availability[]
	 */
	public function getAllByIdent(): array
	{
		$result = [];

		foreach ($this->getAll() as $row) {
			$result[$row->getIdent()] = $row;
		}

		return $result;
	}

	/**
	 * @param int|string $id
	 * @throws EntityHasRelations
	 */
	public function remove($id): bool
	{
		$inProducts = $this->em->getRepository(Product::class)->countBy(['availability' => $id, 'isDeleted' => 0]);

		if ($inProducts > 0) {
			throw new EntityHasRelations('eshopCatalog.availability.removeFailedHasProducts');
		}

		return parent::remove($id);
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptions === null) {
			$this->cOptions = [];

			foreach ($this->getEr()->createQueryBuilder('a')
				         ->select('a.id, at.name')
				         ->innerJoin('a.texts', 'at', 'WITH', 'at.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOptions[$row['id']] = $row['name'];
			}
		}

		return $this->cOptions;
	}

}