<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Import;

class TypeProduct extends ATypeProduct
{
	public $title = 'eshopCatalog.import.typeProduct';

	public $name = 'eshopCatalog.product';

	/**
	 * @inheritDoc
	 */
	public function getFormContainer(array $importKeys, array $importValues, $defaults)
	{
		$this->formContainerFields = [
			'ean'                  => ['type' => 'sel'],
			'code1'                => ['type' => 'sel'],
			'code2'                => ['type' => 'sel'],
			'supplierCode'         => ['type' => 'sel'],
			'isAssort'             => ['type' => 'comparison'],
			'name'                 => ['type' => 'sel', 'multilang' => true],
			'shortDescription'     => ['type' => 'sel', 'multilang' => true],
			'description'          => ['type' => 'sel', 'multilang' => true],
			'quantity'             => ['type' => 'sel'],
			'inStock'              => ['type' => 'comparison'],
			'category'             => ['type' => 'sel', 'fixed' => false],
			'priceVat'             => ['type' => 'sel', 'canModifyInt' => true],
			'retailPrice'          => ['type' => 'sel', 'canModifyInt' => true],
			'purchasePrice'        => ['type' => 'sel', 'canModifyInt' => true],
			'vatRate'              => ['type' => 'sel'],
			'manufacturer'         => ['type' => 'sel'],
			'isPublished'          => ['type' => 'bol'],
			'idAvailability'       => ['type' => 'comparison'],
			'imagesUrlPrefix'      => ['type' => 'sel'],
			'images'               => ['type' => 'slist'],
			'params'               => ['type' => 'slist'],
			'width'                => ['type' => 'sel', 'canModifyInt' => true],
			'height'               => ['type' => 'sel', 'canModifyInt' => true],
			'depth'                => ['type' => 'sel', 'canModifyInt' => true],
			'weight'               => ['type' => 'sel', 'canModifyInt' => true],
			'allowedManufacturers' => ['type' => 'bol', 'secondType' => 'addCheckboxList'],
			'variant'              => ['type' => 'sel'],
			'recyclingFee'         => ['type' => 'sel', 'canModifyInt' => true],
		];

		return parent::getFormContainer($importKeys, $importValues, $defaults);
	}

}