<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\ProductPrice;

/**
 * @method ProductPrice|null getReference($id)
 * @method ProductPrice[] getAll()
 */
class ProductPrices extends BaseEntityService
{
	protected $entityClass = ProductPrice::class;

	public function getByIdAndCountry(int $productId, string $country): ?ProductPrice
	{
		/** @var ?ProductPrice $result */
		$result = $this->getEr()->findOneBy(['product' => $productId, 'country' => $country]);

		return $result;
	}

	public function getByProductId(int $productId): array
	{
		return $this->getEr()->findBy(['product' => $productId]);
	}

}
