<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use EshopCatalog\Model\Entities\Category;
use EshopCatalog\Model\Entities\CategoryRelated;

/**
 * @method CategoryRelated|null getReference($id)
 * @method CategoryRelated[] getAll()
 * @method CategoryRelated|null get($id)
 */
class RelatedCategories extends BaseEntityService
{
	use TPosition;

	protected            $entityClass = CategoryRelated::class;
	protected Translator $translator;

	public function __construct(
		Translator $translator
	)
	{
		$this->translator = $translator;
	}

	public function add(int $category, int $target, string $key = 'category'): ?CategoryRelated
	{
		try {
			/** @var Category $categoryEntity */
			$categoryEntity = $this->em->getReference(Category::class, $category);

			$entity            = new CategoryRelated($categoryEntity, $target);
			$entity->targetKey = $key;

			$this->em->persist($entity);
			$this->em->flush();

			return $entity;
		} catch (\Exception $e) {

		}

		return null;
	}

	public function getByCategory(int $id): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('cr')
			         ->where('cr.category = :id')
			         ->setParameter('id', $id)
			         ->orderBy('cr.position')
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['id']] = $row;
		}

		return $arr;
	}

}
