<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\ImportExport\DuplicatedCategoryData;
use EshopCatalog\AdminModule\Components\ImportExport\DuplicatedProductData;
use EshopCatalog\AdminModule\Components\ImportExport\IDuplicatedCategoryDataFactory;
use EshopCatalog\AdminModule\Components\ImportExport\IDuplicatedProductDataFactory;
use EshopCatalog\AdminModule\Components\ImportExport\IMissingTextFactory;
use EshopCatalog\AdminModule\Components\ImportExport\IProductsByManufacturerFactory;
use EshopCatalog\AdminModule\Components\ImportExport\MissingText;
use EshopCatalog\AdminModule\Components\ImportExport\ProductsByManufacturer;

class ImportExportDataPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('eshopCatalog.title.importExportData', 'fas fa-exchange-alt');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentProductsByManufacturer(IProductsByManufacturerFactory $factory): ProductsByManufacturer
	{
		return $factory->create();
	}

	protected function createComponentDuplicatedProductData(IDuplicatedProductDataFactory $factory): DuplicatedProductData
	{
		return $factory->create();
	}

	protected function createComponentDuplicatedCategoryData(IDuplicatedCategoryDataFactory $factory): DuplicatedCategoryData
	{
		return $factory->create();
	}

	protected function createComponentMissingText(IMissingTextFactory $factory):MissingText
	{
		return $factory->create();
	}

}