<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\Tags\ITagFormFactory;
use EshopCatalog\AdminModule\Components\Tags\ITagsGridFactory;
use EshopCatalog\AdminModule\Components\Tags\TagForm;
use EshopCatalog\AdminModule\Components\Tags\TagsGrid;
use Core\Model\UI\Form\BaseForm;

class TagsPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	public function handleAddTag(): void
	{
		$this->template->modalTitle = $this->t('eshopCatalog.title.newTag');
		$this->template->modal      = 'tagForm';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('eshopCatalog.title.tags', 'fas fa-tags');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.newTag',
				'link'  => $this->link('addTag!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentTagsGrid(ITagsGridFactory $factory): TagsGrid
	{
		return $factory->create();
	}

	protected function createComponentTagForm(ITagFormFactory $factory): TagForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setTag((int) $this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this['tagsGrid']['grid']->reload();
			$this->payload->hideModalName = 'modal';
			$this['tagsGrid']->handleEdit((int) $form->getCustomData('tagId'));
			$this->redrawControl('flashes');
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->payload->hideModal = true;
			$this->redrawControl('flashes');
			$this['tagsGrid']['grid']->reload();
		};
		$control['form']->getComponent('saveControl')->closeModalOnCancel();

		return $control;
	}

}