<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization;

class AlternativeProducts extends PersonalizationControl
{
	protected Personalization $personalization;
	protected int $size;

	public function __construct(Personalization $personalization)
	{
		$this->personalization = $personalization;
	}

	public function render(int $productId): void
	{
		$this->template->apiUrlCtr = $this->link('sendCtr!');
		$this->template->productId = $productId;
		$this->template->productIds = $this->personalization->getAlternativeProductIds($productId);
		$this->template->render($this->getTemplateFile());
	}

	public function handleSendCtr(): void
	{
		$req = $this->presenter->request;
		$this->personalization->increaseCtr((int) $req->getParameter('id'), (int) $req->getPost('productId'));
	}

}