<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use Core\Model\Application\AppState;
use Core\Model\UI\Form\BaseForm;
use Currency\Model\Entities\Currency;
use EshopCatalog\Model\Config;
use Nette\Http\Url;
use Nette\Utils\ArrayHash;

class AutocompleteForm extends PersonalizationControl
{
	protected int $size;
	protected string $currency;
	protected string $currencyText;

	public function __construct()
	{
		/** @var Currency|null $currency */
		$currency = AppState::getState('currency');
		$this->size = (int) Config::load('personalization.autocompleteForm.size');
		$this->currency = $currency ? $currency->getCode() : 'czk';
		$this->currencyText = $currency ? $currency->symbol : 'Kč';
	}

	public function render(): void
	{
		$this->template->currencyText = $this->currencyText;
		$this->template->apiUrl = $this->apiUrl('__VAL__');
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAction($this->getPresenter()->link(':EshopCatalog:Front:Default:search'));
		$form->setMethod('post');
		$form->getElementPrototype();
		$form->setShowLangSwitcher(false)->setHtmlAttribute('id', 'autocomplete-form');

		$form->addText('q');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$this->getPresenter()->redirect(':EshopCatalog:Front:Default:search', ['q' => ($values->q)]);
	}

	protected function apiUrl(string $query): Url
	{
		$url = new Url($this->apiBaseUrl);
		$url->setPath('/api/v1/recommended-products/autocomplete');
		$url->setQueryParameter('q', $query);
		$url->setQueryParameter('size', $this->size);
		$url->setQueryParameter('lang', $this->translator->getLocale());
		$url->setQueryParameter('currency', $this->currency);

		return $url;
	}

}