<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization;

class CrossSellProducts extends PersonalizationControl
{
	protected Personalization $personalization;
	protected int $size;

	public function __construct(Personalization $personalization)
	{
		$this->personalization = $personalization;
	}

	public function render(int $productId): void
	{
		$this->template->productIds = $this->personalization->getCrossSellProducts($productId);
		$this->template->render($this->getTemplateFile());
	}

}