<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__category_filter")
 * @ORM\Entity
 * @ORM\EntityListeners({"CategoryFilterListener"})
 */
class CategoryFilter
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="filters")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Category $category;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @ORM\Column(type="integer")
	 */
	public int $position;

	/**
	 * @ORM\Column(type="integer", options={"default": 0, "unsigned": true})
	 */
	public int $isHidden = 0;

	public function __construct(Category $category, Feature $feature, int $position)
	{
		$this->category = $category;
		$this->feature  = $feature;
		$this->position = $position;
	}

}
