<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__category_related", indexes={@ORM\Index(name="category", columns={"category_id"})})
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class CategoryRelated
{
	use TId;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="related")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Category $category;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=false)
	 */
	public int $target;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $targetKey = 'category';

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer", nullable=false)
	 */
	protected int $position = 0;

	public function __construct(Category $category, int $target)
	{
		$this->category = $category;
		$this->target   = $target;
		$this->setPosition(-1);
	}

	public function setPosition(int $pos): void { $this->position = $pos; }

}