<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Payment;

/**
 * @ORM\Table(name="eshop_catalog__product_payment")
 * @ORM\Entity
 */
class ProductPayment
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="payments")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Payment $payment;

	/**
	 * @ORM\Column(name="payment_disabled", type="smallint", length=1, options={"default": 0})
	 */
	public int $paymentDisabled = 0;

	public function __construct(Product $product, Payment $payment)
	{
		$this->product = $product;
		$this->payment = $payment;
	}

}
