<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use EshopCatalog\FrontModule\Components\IProductPreviewFactory;
use Nette\Application\UI\Multiplier;

class DynamicComponent
{
	public static function createProductPreview(IProductPreviewFactory $factory): Multiplier
	{
		return new Multiplier(function(string $id) use ($factory) {
			$control = $factory->create();

			$control->setProductById((int) $id);

			return $control;
		});
	}
}
