<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Helpers\Strings;
use Core\Model\Images\ImagePipe;
use Nette\Utils\Image;

class FeaturesHelper
{
	protected ImagePipe $imagePipe;

	public function __construct(ImagePipe $imagePipe)
	{
		$this->imagePipe = $imagePipe;
	}

	public function parseValueColors(string $val): array
	{
		if (Strings::startsWith($val, '/')) {
			$arr['pattern']     = $val;
			$arr['colorsStyle'] = 'background-image: url(\'' . $this->imagePipe->request($val, '80x80', Image::EXACT) . '\');';
		} else {
			$arr    = [];
			$colors = [];

			foreach (explode(',', $val) as $v) {
				if ($v) {
					$colors[] = $v;
				}
			}

			$colorsCount = count($colors);

			$arr['colors'] = $colors;
			if ($colorsCount === 2) {
				$arr['colorsStyle'] = 'background: linear-gradient(135deg, ' . $colors[0] . ' 50%, ' . $colors[1] . ' 50%);';
			} else if ($colorsCount === 3) {
				$arr['colorsStyle'] = 'background: linear-gradient(135deg, ' . $colors[0] . ' 33.3%, ' . $colors[1] . ' 33.3%, ' . $colors[1] . ' 66.6%, ' . $colors[2] . ' 66.6%);';
			} else {
				$arr['colorsStyle'] = 'background-color: ' . $colors[0] . ';';
			}
		}

		return $arr;
	}

}
