<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__vat_rate")
 * @ORM\Entity
 */
class VatRate {
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;
	
	/**
	 * @var int
	 * @ORM\Column(name="rate", type="smallint")
	 */
	public $rate;
}
