import {getJson} from 'AdminCoreJs/utils/Functions';

document.addEventListener('DOMContentLoaded', () => {
	initFeatures();
	initVariables();
});

const initFeatures = () => {
	const featuresTab = document.getElementById('formFeature');
	const valuesList  = document.querySelector('.feature-values-list');
	if (!featuresTab)
		return;

	const data = document.features;

	featuresTab.querySelectorAll('[data-create-feature]').forEach(el => {
		el.addEventListener('click', e => {
			e.preventDefault();
			const featureId = el.dataset.createFeature;
			const feature   = data.features[featureId];

			let wrap = document.createElement('div');
			wrap.classList.add('feature-values-list__feature');

			let frmPair = document.createElement('div');
			frmPair.classList.add('frm__pair');

			let removeWrap = frmPair.cloneNode();
			let remove     = document.createElement('a');
			remove.setAttribute('href', 'javascript:;');
			remove.classList.add('btn', 'btn-danger', 'ml-5', 'mb-0');
			remove.setAttribute('data-remove-feature-value', true);
			remove.innerHTML = '<i class="fas fa-trash-alt"></i>';
			remove.addEventListener('click', removeFeature);
			removeWrap.appendChild(remove);

			switch (feature.type) {
				case 'check':
					let selectWrap = frmPair.cloneNode();
					selectWrap.classList.add('frm__type-select');
					selectWrap.innerHTML = '<label>' + feature.name + '</label>';

					let select = document.createElement('select');
					select.setAttribute('name', 'features[]');

					for (let k in data.values[featureId]) {
						let row = data.values[featureId][k];

						let option         = document.createElement('option');
						option.value       = row.id;
						option.textContent = row.name;

						select.appendChild(option);
					}

					selectWrap.appendChild(select);

					let text = frmPair.cloneNode();
					text.classList.add('frm__type-text');
					text.innerHTML = '<label></label>';

					let input = document.createElement('input');
					input.setAttribute('type', 'text');
					input.setAttribute('data-create-feature-id', featureId);
					input.setAttribute('placeholder', featuresTab.dataset.addFeatureValueText);
					input.addEventListener('keypress', createFeatureValue);
					text.appendChild(input);

					let addWrap = frmPair.cloneNode();
					let add     = document.createElement('a');
					add.setAttribute('href', 'javascript:;');
					add.classList.add('btn', 'btn-success', 'mb-0');
					add.setAttribute('data-save-new-feature-value', true);
					add.innerHTML = '<i class="fa fa-plus"></i>';
					add.addEventListener('click', clickCreateValue);
					addWrap.appendChild(add);

					wrap.appendChild(selectWrap);
					wrap.appendChild(text);
					wrap.appendChild(addWrap);
					wrap.appendChild(removeWrap);

					break;
				case 'range':
					let textWrap = frmPair.cloneNode();
					textWrap.classList.add('frm__type-select');
					textWrap.innerHTML =
						'<label>' + feature.name + '</label><input type="text" step=".01" maxlength="10" name="dynamicFeatures[' + featureId + ']">';

					wrap.appendChild(textWrap);
					wrap.appendChild(removeWrap);

					break;
			}

			valuesList.appendChild(wrap);

			document.dispatchEvent(new CustomEvent('formInputsInit', {
				bubbles   : true,
				cancelable: true,
			}));
		});
	});

	valuesList.querySelectorAll('[data-remove-feature-value]').forEach(el => {
		el.addEventListener('click', e => {
			removeFeature(e);
		});
	});

	valuesList.querySelectorAll('[data-save-new-feature-value]').forEach(el => {
		el.addEventListener('click', e => {
			clickCreateValue(e);
		});
	});

	valuesList.querySelectorAll('[data-create-feature-id]').forEach(el => {
		el.addEventListener('keypress', e => {
			createFeatureValue(e);
		});
	});

	const removeFeature = (e) => {
		let target = e.target;

		e.preventDefault();
		target.closest('.feature-values-list__feature').remove();
	};

	const createFeatureValue = (e) => {
		if (e.keyCode == 13) {
			e.preventDefault();
			let el        = e.target;
			let featureId = el.dataset.createFeatureId;

			// Povoleníé přidání vlastnosti entrem
			if (featureId) {
				let link = featuresTab.dataset.linkCreateValue.replace('__id__', featureId).replace('__val__', el.value);
				global.naja.makeRequest('get', link, [], {
					history: false,
				}).then(response => {
					let wrap   = el.closest('.feature-values-list__feature');
					let select = wrap.querySelector('select');

					if (response.data.created) {
						let option   = document.createElement('option');
						option.value = response.data.id;
						option.text  = response.data.name;
						select.add(option);
					}

					select.value = response.data.id;
					el.value     = '';

					const choices = select.dataset.choicesIndex ? global.choicesList[select.dataset.choicesIndex] : null;
					if (choices) {
						choices.setChoices([{
							value: response.data.id, label: response.data.name,
						}], 'value', 'label', false);
						choices.setChoiceByValue(response.data.id);
					}
				});
			}

			e.preventDefault();
			return false;
		}
	};

	const clickCreateValue = (e) => {
		e.target.parentElement.previousElementSibling.children[1].dispatchEvent(new KeyboardEvent('keypress', {
			'keyCode': 13,
		}));
	}

	const featureSearchInput = document.getElementById('features-search__input');
	const featureValuesList  = {};

	// Vytahnuti vsech vlastnosti
	document.querySelectorAll('.feature-values-list__feature').forEach(el => {
		featureValuesList[el.dataset.id] = el;
	});


	document.querySelectorAll('[data-save-new-feature-value]').forEach(el => {
		el.addEventListener('click', e => {
			e.preventDefault();
		})
	});

	// Hledani ve vlastnostech
	if (featureSearchInput) {
		const featuresSearchListItems = featureSearchInput.nextElementSibling.querySelectorAll('.features-list__item');

		if (featuresSearchListItems) {
			featureSearchInput.addEventListener('keyup', e => {
				let search = featureSearchInput.value;

				if (search.length < 2) {
					featuresSearchListItems.forEach(el => {
						el.style.display = 'block';
					});
				} else {
					let regEx = new RegExp(featureSearchInput.value, 'i');
					featuresSearchListItems.forEach(el => {
						if (el.innerText.match(regEx))
							el.style.display = 'block';
						else
							el.style.display = 'none';
					});
				}
			});
		}
	}

	const setAsVariantForBtn = document.getElementById('setAsVariantForBtn');
	if (setAsVariantForBtn) {
		const setAsVariantForInput = setAsVariantForBtn.nextElementSibling;

		setAsVariantForInput.addEventListener('keypress', e => {
			if (e.keyCode == 13) {
				e.preventDefault();

				setAsVariantForBtn.dispatchEvent(new Event('click'));
				return false;
			}
		})

		setAsVariantForBtn.addEventListener('click', e => {
			e.preventDefault();
			let value = setAsVariantForInput.value;

			if (!value)
				setAsVariantForInput.classList.add('frm__input-error');
			else {
				setAsVariantForInput.classList.remove('frm__input-error');

				global.naja.makeRequest('post', setAsVariantForBtn.href, {
					productId: value,
				}, {
					history      : false,
					forceRedirect: true,
				});
			}

			return false;
		});
	}
};

const initVariables = () => {
	document.querySelectorAll('#snippet-productForm-form .variant-use-bool').forEach(el => {
		el.querySelector('input').addEventListener('change', e => {
			el.classList.toggle('active');
		});
	});
};
