import {checkMedia}         from "core/js/utils/utilities";
import {slideDown, slideUp} from "es6-slide-up-down";

/**
 * Fix modal okna
 */
global.naja.snippetHandler.addEventListener('afterUpdate', (event) => {
	if (event.snippet.id.indexOf('variantsPopup-modal') !== -1) {
		document.documentElement.classList.add('overflow-hidden');
	}
})

/**
 * Zobrazení hledání
 */
window.showSearch = function () {
	document.querySelector('.shop-header__search').classList.toggle('active');
};

/**
 * Přesunutí košíku - mobil vs desktop
 */
let shopHeaderCartLastPos = 'desktop';
const moveShopHeaderCart  = () => {
	let mobileSize = checkMedia(document.body.dataset.responsiveBarThreshold);
	let moveTo     = null;
	if (mobileSize && shopHeaderCartLastPos === 'desktop')
		moveTo = 'mobile';
	else if (!mobileSize && shopHeaderCartLastPos === 'mobile')
		moveTo = 'desktop';

	if (moveTo) {
		let shopHeaderCartMobile  = document.querySelector('.shop-header__cart-mobile');
		let shopHeaderCartDesktop = document.querySelector('.show-header__cart-desktop');

		if (moveTo === 'mobile') {
			if (!shopHeaderCartDesktop) return;
			while (shopHeaderCartDesktop.childNodes.length > 0)
				shopHeaderCartMobile.appendChild(shopHeaderCartDesktop.childNodes[0]);
			shopHeaderCartLastPos = 'mobile';
		} else if (moveTo === 'desktop') {
			if (!shopHeaderCartMobile) return;
			while (shopHeaderCartMobile.childNodes.length > 0)
				shopHeaderCartDesktop.appendChild(shopHeaderCartMobile.childNodes[0]);
			shopHeaderCartLastPos = 'desktop';
		}
	}
}
document.addEventListener('DOMContentLoaded', () => {
	moveShopHeaderCart();
	window.addEventListener('resize', (e) => {
		moveShopHeaderCart();
	});
});

document.addEventListener('click', e => {
	const target = e.target;
	let el       = null;

	/**
	 * Skryvani a odkryvani polozek v eshop-nav__secondary
	 */
	el = target.closest('[data-show-more-items]');
	if (el !== null) {
		const moreText      = el.getAttribute('data-more-text');
		const lessText      = el.getAttribute('data-less-text');
		const text          = el.querySelector('div');
		const parent        = el.parentNode;
		const targetElement = parent.querySelector(`[data-hidden-items]`);
		if (!targetElement.classList.contains('active')) {
			slideDown(targetElement);
			text.innerHTML = lessText;
			targetElement.classList.add('active');
		} else {
			slideUp(targetElement);
			text.innerHTML = moreText;
			targetElement.classList.remove('active');
		}
	}
});
