<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Exceptions\EntityHasRelations;
use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\VatRate;

/**
 * Class VatRates
 * @package EshopCatalog\AdminModule\Model
 *
 * @method VatRate|null|object getReference($id)
 * @method VatRate[]|null getAll()
 * @method VatRate|null get($id)
 */
class VatRates extends BaseEntityService
{
	protected $entityClass = VatRate::class;

	protected array $cList = [];

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws EntityHasRelations
	 * @throws \Doctrine\ORM\NoResultException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function remove($id): bool
	{
		$inProducts = $this->em->getRepository(Product::class)->countBy(['vatRate' => $id]);

		if ($inProducts > 0)
			throw new EntityHasRelations('eshopCatalog.vatRate.removeFailedHasProducts');

		return parent::remove($id);
	}

	public function getListByRate(): array
	{
		if (!empty($this->cList)) {
			return $this->cList;
		}

		foreach ($this->getAll() as $v) {
			$this->cList[$v->rate] = $v;
		}

		return $this->cList;
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('vr')->select('vr.id, vr.name')
			         ->getQuery()->getScalarResult() as $row)
			$arr[$row['id']] = $row['name'];

		return $arr;
	}

	public function getListForPohoda(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('vr')->select('vr.rate', 'vr.pohodaRate')
			         ->getQuery()->getArrayResult() as $row) {
			if (!$row['pohodaRate'])
				continue;

			$arr['byRate'][$row['rate']] = $row['pohodaRate'];

			$sumKey                       = $row['pohodaRate'] === 'third' ? '3' : ucfirst($row['pohodaRate']);
			$arr['summary'][$row['rate']] = 'price' . $sumKey;
		}

		return $arr;
	}
}
