<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Categories;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 *
	 * @param Category           $category
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postUpdateHandler(Category $category, LifecycleEventArgs $event)
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['categories']]);
	}

	/**
	 * @ORM\PostRemove
	 *
	 * @param Category           $category
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postRemoveHandler(Category $category, LifecycleEventArgs $event)
	{
		$tags2 = [
			Categories::CACHE_NAMESPACE,
		];

		if ($category->getParent()) {
			$tags2[] = 'category/' . $category->getParent()->getId();
		}

		$this->cacheService->clean('category', [Cache::TAGS => $tags2]);
	}
}
