<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class ProductsFeedEvent extends Event
{
	public ?string $customerName;

	public string $outputFormat;

	public array $data;

	public function __construct(array &$data, ?string $customerName, string $outputFormat = 'json')
	{
		$this->data         = &$data;
		$this->outputFormat = &$outputFormat;
		$this->customerName = $customerName;
	}
}
