<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class GoogleExportEnums
{
	public static array $list = [
		'color'     => [
			'title' => 'eshopCatalog.googleType.color',
		],
		'gender'    => [
			'title' => 'eshopCatalog.googleType.gender',
			'items' => [
				'male'   => 'eshopCatalog.googleTypeItems.male',
				'female' => 'eshopCatalog.googleTypeItems.female',
				'unisex' => 'eshopCatalog.googleTypeItems.unisex',
			],
		],
		'age_group' => [
			'title' => 'eshopCatalog.googleType.ageGroup',
			'items' => [
				'newborn' => 'eshopCatalog.googleTypeItems.newborn',
				'infant'  => 'eshopCatalog.googleTypeItems.infant',
				'toddler' => 'eshopCatalog.googleTypeItems.toddler',
				'kids'    => 'eshopCatalog.googleTypeItems.kids',
				'adult'   => 'eshopCatalog.googleTypeItems.adult',
			],
		],
		'material'  => [
			'title' => 'eshopCatalog.googleType.material',
		],
		'pattern'   => [
			'title' => 'eshopCatalog.googleType.pattern',
		],
		'size'      => [
			'title' => 'eshopCatalog.googleType.size',
		],
		'size_type' => [
			'title' => 'eshopCatalog.googleType.sizeType',
		],
	];

	public static function getListForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v)
			$arr[$k] = $v['title'];

		return $arr;
	}

	public static function getListItemsForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v) {
			if (!isset($v['items']))
				continue;

			foreach ($v['items'] as $vk => $vv)
				$arr[$k][$vk] = $vv;
		}

		return $arr;
	}
}
