<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\Model\Entities\Product;

class PseudoWarehouse
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	protected function getUnlimitedProducts(array $ids): array
	{
		$unlimited = [];
		foreach ($this->em->getRepository(Product::class)->createQueryBuilder('p')
			         ->select('p.id')
			         ->where('p.id IN (:ids)')
			         ->setParameter('ids', array_values($ids))
			         ->andWhere('p.unlimitedQuantity = 1')
			         ->getQuery()->getScalarResult() as $row)
			$unlimited[] = $row['id'];

		return $unlimited;
	}

	public function lowerQuantities(array $data): void
	{
		$unlimited = $this->getUnlimitedProducts(array_keys($data));

		foreach ($data as $productId => $quantity) {
			if (in_array($productId, $unlimited))
				continue;

			$product           = $this->em->getReference(Product::class, $productId);
			$product->quantity -= $quantity;
			$this->em->persist($product);
			$this->em->flush($product);
		}
	}

	public function raiseQuantities(array $data): void
	{
		$unlimited = $this->getUnlimitedProducts(array_keys($data));

		foreach ($data as $productId => $quantity) {
			if (in_array($productId, $unlimited))
				continue;

			$product           = $this->em->getReference(Product::class, $productId);
			$product->quantity += $quantity;
			$this->em->persist($product);
			$this->em->flush($product);
		}
	}
}
