<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Exceptions\EntityHasRelations;
use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\VatRate;

/**
 * Class VatRates
 * @package EshopCatalog\AdminModule\Model
 *
 * @method VatRate|null|object = getReference($id)
 * @method VatRate[]|null getAll()
 * @method VatRate|null get($id)
 */
class VatRates extends BaseEntityService
{
	protected $entityClass = VatRate::class;

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws EntityHasRelations
	 * @throws \Doctrine\ORM\NoResultException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function remove($id): bool
	{
		$inProducts = $this->em->getRepository(Product::class)->countBy(['vatRate' => $id]);

		if ($inProducts > 0)
			throw new EntityHasRelations('eshopCatalog.vatRate.removeFailedHasProducts');

		return parent::remove($id);
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('vr')->select('vr.id, vr.name')
			         ->getQuery()->getScalarResult() as $row)
			$arr[$row['id']] = $row['name'];

		return $arr;
	}
}
