<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\ImportExport\IProductsByManufacturerFactory;
use EshopCatalog\AdminModule\Components\ImportExport\ProductsByManufacturer;

class ImportExportDataPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('eshopCatalog.title.importExportData', 'fas fa-exchange-alt');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentProductsByManufacturer(IProductsByManufacturerFactory $factory): ProductsByManufacturer
	{
		return $factory->create();
	}
}

